import Link from "next/link";
import { getCompanies, getPosts } from "./actions";
import Sidebar from "@/components/Sidebar";
import ClientPage from "@/components/ClientPage";

import type { Post } from "@prisma/client";

export const dynamic = "force-dynamic";

export default async function Page({
  searchParams,
}: {
  searchParams: Promise<{ [key: string]: string | string[] | undefined }>;
}) {
  const companies = await getCompanies();
  const { companyId } = await searchParams;
  const idStr = Array.isArray(companyId) ? companyId[0] : companyId;

  let selectedCompany = null;
  let posts: Post[] = [];

  if (idStr) {
    selectedCompany = companies.find((c) => c.id === idStr) || null;
    if (selectedCompany) {
      posts = await getPosts(idStr);
    }
  }

  return (
    <div className="flex flex-col lg:flex-row h-screen bg-white overflow-hidden">
      <Sidebar companies={companies} />
      <main className="flex-1 h-full overflow-hidden">
        {selectedCompany ? (
          <ClientPage company={selectedCompany} initialPosts={posts} />
        ) : (
          <div className="flex h-full items-center justify-center text-zinc-500">
            <div className="text-center">
              <h3 className="text-lg font-medium">Firma Seçin</h3>
              <p className="text-sm mt-1">İşlem yapmak için soldan bir firma seçin veya yeni ekleyin.</p>
            </div>
          </div>
        )}
      </main>
    </div>
  );
}
